/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.security;

import catserver.server.AsyncCatcher;
import catserver.server.CatServer;
import catserver.server.remapper.ReflectionUtils;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.bukkit.craftbukkit.v1_12_R1.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.plugin.java.PluginClassLoader;

public class OpSecurityManager {
    private static final MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
    private static final Map<GameProfile, Class<?>[]> profileStackMap = new Object2ObjectArrayMap();

    public static void addOpHook(GameProfile profile) {
        if (!CatServer.getConfig().securityOpManager) {
            return;
        }
        if (!AsyncCatcher.isMainThread()) {
            throw new RuntimeException("Async add op!");
        }
        Class<?>[] callerStack = ReflectionUtils.getCallerStack();
        if ((callerStack = Arrays.copyOfRange(callerStack, 4, callerStack.length - 1))[0] == ct.class) {
            CatServer.log.info("Player {}/{} got op, the stacktrace saved in debug.log", (Object)profile.getName(), (Object)profile.getId());
            CatServer.log.debug(OpSecurityManager.class.getName(), new Throwable());
            return;
        }
        if (callerStack[0] == CraftPlayer.class || callerStack[0] == CraftOfflinePlayer.class) {
            callerStack = Arrays.copyOfRange(callerStack, 1, callerStack.length - 1);
        }
        profileStackMap.put(profile, callerStack);
    }

    public static void removeOpHook(GameProfile profile) {
        if (!CatServer.getConfig().securityOpManager) {
            return;
        }
        if (!AsyncCatcher.isMainThread()) {
            server.a(() -> server.am().b(profile));
            throw new RuntimeException("Async de-op!");
        }
        Class<?>[] callerStack = ReflectionUtils.getCallerStack();
        if ((callerStack = Arrays.copyOfRange(callerStack, 4, callerStack.length - 1))[0] == by.class) {
            CatServer.log.info("Player {}/{} de-op, the stacktrace saved in debug.log", (Object)profile.getName(), (Object)profile.getId());
            CatServer.log.debug(OpSecurityManager.class.getName(), new Throwable());
            return;
        }
        profileStackMap.remove(profile);
    }

    public static void tick() {
        if (!CatServer.getConfig().securityOpManager) {
            return;
        }
        profileStackMap.forEach((profile, callerStack) -> {
            try {
                CatServer.log.warn("Detected player {}/{} got op without command. Please check server security!", (Object)profile.getName(), (Object)profile.getId());
                for (Class stack : callerStack) {
                    if (stack.getClassLoader() instanceof PluginClassLoader) {
                        PluginClassLoader pluginClassLoader = (PluginClassLoader)stack.getClassLoader();
                        CatServer.log.warn("Stacktrace: {} (Plugin: {})", (Object)stack.getName(), (Object)pluginClassLoader.getDescription().getName());
                        continue;
                    }
                    CatServer.log.warn("Stacktrace: {}", (Object)stack.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                server.am().h().a((po)new pr(profile, null, OpSecurityManager.class.getName(), null, null));
                server.am().b(profile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                oq player = server.am().a(profile.getId());
                if (player != null && player.a != null) {
                    hp chatcomponenttext = new hp("", new Object[0]);
                    if (player.a.a != null) {
                        player.a.a.a((hh)chatcomponenttext);
                        player.a.a.k();
                    }
                    player.a.a((hh)chatcomponenttext);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        profileStackMap.clear();
    }
}

